function [last_episodes, av_all_episodes]=simulation_rep_accommodation(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,K,BR)

%In this accommodation case player 1 is an AM and player 2 is a human with a
%dynamic manipulation strategy, aimed at "teaching" player 1 to play above the monopoly price.

%This function returns:

%last_episodes: a K x 6 matrix with the values in the last episode T of
%A_1, A_2, profit 1, profit 2, v_tilde, l, for every experiment.

%av_all_episodes: A Tx12 matrix containing for each episode t the mean across experiments 
%of A_1, A_2, opt_1, Profit_1, Profit_2, a_min, and the means of the squared values of these
%variables.

%Initialize
last_episodes = zeros(K,6);
av_all_episodes = zeros(T,12);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.
parfor k=1:K
    %Calls the function simulation_exp_accommodation
    [last_episode,all_episodes] = simulation_exp_accommodation(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,BR);
    %Records the last episode
    last_episodes(k,:) = last_episode;
    %Adds the values of all episodes to the existing av_all_episodes
    av_all_episodes = av_all_episodes + all_episodes;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end

%Divide av_all_episodes by K to get the average across all experiments:
av_all_episodes = av_all_episodes/K;
